package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;

public class SWP_AdvancedAICore extends BaseHullMod {

    public static final float AUTOAIM_BONUS = 50f;
    public static final float RECOIL_BONUS = 50f;

    @Override
    public void applyEffectsBeforeShipCreation(HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getAutofireAimAccuracy().modifyFlat(id, AUTOAIM_BONUS * 0.01f);
        stats.getMaxRecoilMult().modifyMult(id, 1f - RECOIL_BONUS * 0.01f);
        stats.getRecoilPerShotMult().modifyMult(id, 1f - RECOIL_BONUS * 0.01f);
    }

    @Override
    public String getDescriptionParam(int index, HullSize hullSize) {
        if (index == 0) {
            return "" + (int) RECOIL_BONUS;
        }
        return null;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().getHullMods().contains("ii_fire_control")) {
            return "Incompatible with Imperial FFCS Core";
        }

        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("ii_fire_control")) {
            return false;
        }

        return true;
    }
}
